/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// GPU Particle Example 2
// By: Brandon Fogerty
// bfogerty at gmail dot com
//modified by Mohit Hingorani


#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 resolution;

#define HorizontalAmplitude		0.80
#define VerticleAmplitude		0.50
#define HorizontalSpeed			0.90
#define VerticleSpeed			0.50
#define ParticleMinSize			1.76
#define ParticleMaxSize			1.71
#define ParticleBreathingSpeed		0.10
#define ParticleColorChangeSpeed	0.10
#define ParticleCount			20.0
#define ParticleColor1			vec3(9.0, 5.0, 3.0)
#define ParticleColor2			vec3(1.0, 3.0, 9.0)

void main( void ) 
{
	vec2 pos = ( scaled_gl_FragCoord.xy / resolution.xy ) * 2.0 - 1.0;
	pos.x *= (resolution.x / resolution.y);
	
	vec3 c = vec3( 0, 0, 0 );
	
	for( float i = 1.0; i < ParticleCount+1.0; ++i )
	{
		float cs = cos( time  * (i/ParticleCount) ) ;
		float ss = sin( time  * (i/ParticleCount) ) ;
		vec2 origin = vec2( cs , ss );
		
		float t = sin( time * ParticleBreathingSpeed * i ) * 0.5 + 0.5;
		float particleSize = mix( ParticleMinSize, ParticleMaxSize, t );
		float d = clamp( sin( length( pos - origin )  + particleSize ), 0.0, particleSize);
		
		vec3 color = vec3( 0.4,0.3,0.8);
		c += color * pow( d, 10.0 );
	}

	gl_FragColor = vec4( c, 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}